# RT Table Configuration
echo "228 warp_table" >> /etc/iproute2/rt_tables
uci add network rt_table
uci set network.@rt_table[-1].name='warp_table'
uci set network.@rt_table[-1].id='228'

# IPv4 Rule and Route Configuration
uci add network rule
uci set network.@rule[-1].mark='0xe4'
uci set network.@rule[-1].lookup='warp_table'

uci add network route
uci set network.@route[-1].interface='WARP'
uci set network.@route[-1].target='0.0.0.0/0'
uci set network.@route[-1].table='warp_table'

# IPv6 Rule and Route Configuration
uci add network rule6
uci set network.@rule6[-1].lookup='warp_table'
uci set network.@rule6[-1].mark='0xe4'

uci add network route6
uci set network.@route6[-1].interface='WARP'
uci set network.@route6[-1].target='::/0'
uci set network.@route6[-1].table='warp_table'

# Firewall Rules Configuration
uci add firewall rule
uci set firewall.@rule[-1].name='Mark-Amazon-Traffic'
uci set firewall.@rule[-1].ipset='Amazon_CIDRs'
uci set firewall.@rule[-1].target='MARK'
uci set firewall.@rule[-1].set_mark='0xe4'
uci set firewall.@rule[-1].src='lan'
uci set firewall.@rule[-1].dest='*'
uci set firewall.@rule[-1].priority='1'
uci set firewall.@rule[-1].chain='prerouting'
uci set firewall.@rule[-1].family='ipv4'

# Amazon IP Sets
# Download & parse like this: curl https://ip-ranges.amazonaws.com/ip-ranges.json | jq -r '.prefixes[].ip_prefix' | tee amazon-ip-ranges.txt
uci add firewall ipset
uci set firewall.@ipset[-1].name='Amazon_CIDRs'
uci set firewall.@ipset[-1].family='ipv4'
uci set firewall.@ipset[-1].match='dest_net'
uci set firewall.@ipset[-1].loadfile='/etc/luci-uploads/amazon-ip-ranges.txt'

# Hetzner IPv4 IP Sets
uci add firewall ipset
uci set firewall.@ipset[-1].name='Hetzner_CIDRs_v4'
uci set firewall.@ipset[-1].family='ipv4'
uci set firewall.@ipset[-1].match='dest_net'
uci set firewall.@ipset[-1].entry='116.202.0.0/16' '116.203.0.0/16' '128.140.0.0/17' '135.181.0.0/16' '136.243.0.0/16' '138.199.128.0/17' '138.201.0.0/16' '139.28.242.0/23' '142.132.128.0/17' '144.76.0.0/16' '148.251.0.0/16' '157.180.0.0/17' '157.90.0.0/16' '159.69.0.0/16' '162.55.0.0/16' '167.233.0.0/16' '167.235.0.0/16' '168.119.0.0/16' '171.25.225.0/24' '176.9.0.0/16' '178.212.75.0/24' '178.63.0.0/16' '185.107.52.0/22' '185.126.28.0/22' '185.157.176.0/23' '185.157.178.0/23' '185.157.83.0/24' '185.171.224.0/22' '185.189.228.0/24' '185.189.229.0/24' '185.189.230.0/24' '185.189.231.0/24' '185.213.45.0/24' '185.216.237.0/24' '185.226.99.0/24' '185.228.8.0/23' '185.50.120.0/23' '188.245.0.0/16' '188.34.128.0/17' '188.40.0.0/16' '193.110.6.0/23' '193.163.198.0/24' '194.42.180.0/22' '194.42.184.0/22' '194.62.106.0/24' '195.201.0.0/16' '195.248.224.0/24' '195.60.226.0/24' '197.242.84.0/22' '201.131.3.0/24' '204.29.146.0/24' '213.133.96.0/19' '213.239.192.0/18' '216.55.108.0/22' '23.88.0.0/17' '37.27.0.0/16' '45.145.227.0/24' '46.4.0.0/16' '46.62.128.0/17' '49.12.0.0/16' '49.13.0.0/16' '5.75.128.0/17' '5.9.0.0/16' '65.108.0.0/16' '65.109.0.0/16' '65.21.0.0/16' '78.138.62.0/24' '78.46.0.0/15' '85.10.192.0/18' '88.198.0.0/16' '88.99.0.0/16' '91.107.128.0/17' '91.190.240.0/21' '91.99.0.0/16' '94.130.0.0/16' '95.216.0.0/16' '95.217.0.0/16'

# Hetzner IPv6 IP Sets
uci add firewall ipset
uci set firewall.@ipset[-1].name='Hetzner_CIDRs_v6'
uci set firewall.@ipset[-1].family='ipv6'
uci set firewall.@ipset[-1].match='dest_net'
uci set firewall.@ipset[-1].entry='2a01:4f8::/32' '2a01:4f9::/32' '2a06:be80::/29' '2a0e:7700::/32' '2a11:e980::/29' '2a12:1fc0::/42'

# Hetzner IPv4 Marking Rule
uci add firewall rule
uci set firewall.@rule[-1].name='Mark-Hetzner-IPv4'
uci set firewall.@rule[-1].family='ipv4'
uci set firewall.@rule[-1].src='lan'
uci set firewall.@rule[-1].ipset='Hetzner_CIDRs_v4'
uci set firewall.@rule[-1].target='MARK'
uci set firewall.@rule[-1].set_mark='0xe4'
uci set firewall.@rule[-1].chain='prerouting'
uci set firewall.@rule[-1].dest='*'

# Hetzner IPv6 Marking Rule
uci add firewall rule
uci set firewall.@rule[-1].name='Mark-Hetzner-IPv6'
uci set firewall.@rule[-1].family='ipv6'
uci set firewall.@rule[-1].src='lan'
uci set firewall.@rule[-1].ipset='Hetzner_CIDRs_v6'
uci set firewall.@rule[-1].target='MARK'
uci set firewall.@rule[-1].set_mark='0xe4'
uci set firewall.@rule[-1].chain='prerouting'
uci set firewall.@rule[-1].dest='*'

# Apply changes
uci commit network
uci commit firewall